#!/usr/bin/perl
use strict;
use warnings;

my $raw = join ("", @ARGV);
$raw =~ s/\r//g;                #改行文字削除
$raw =~ s/\n//g;               #副業文字削除
$raw =~ s/\D\)|\(\D\)/+/sg;   #英字)or(英字)を+に変換
$raw =~ s/\+//;                 #先頭の+を除去
$raw =~ s/\.\s+/\./g;           #ピリオドから次のwordまでのスペースを一旦削除
$raw =~ s/\./\. /g;             #ピリオドの後は1スペースに統一
$raw =~ s/\,\s+/\,/g;           #同様にカンマの後のスペースを整形
$raw =~ s/\,/\, /g;
$raw =~ s/\. \,/\.\,/g;         #上の置換では._,となっているのを、.,に訂正
my @ref = split(/\+/, $raw);    #生データを+で区切ってリスト関数refに分配

my @ref_list = ("J. Am.","Angew","J. Org","Org. Lett", "Science", "Nature", "Nat. Chem", "Nat. Mat", "Tetrahedron", "Acc. Chem",
"Chem. Re", "J. Chem. Soc.", "Chem. Commun", "J. Mater. Chem", "Chem. Soc. Rev", "Chem. Asia", "Chem. Eur", "Organomet", "Adv. Synth", "Adv. Mat", "Bioorg", "Chem. Lett", "Bull. Chem", "Macromo","Chem. Sci", "Eur. J.", "J. Nat. Pro", "J. Med.", "J. Organomet", "ACS", "Annu. Rev", "ARKIVOC", "Can. J.","ChemCatChem", "ChemBioChem", "Helv.", "Inorg", "J. Phys. Chem", "Macromol. Rapid", "New J. Chem", "Adv. Funct", "ChemEngCom", "Dalton Trans", "Org. Biomol");  #論文リスト

my @cite_info = ();                     
for(my $i =0; $i < @ref; $i++){     #リスト関数の配列数iつまり論文の数iだけ繰り返す
    my @num = ();                   
    $num[$i] = -1;
    my $n = 0;
    while ($num[$i] == -1){         #上の論文リストに一致すればwhileループ脱出
        $num[$i] = rindex($ref[$i], $ref_list[$n]);  #論文リストに後方一致する場所（先頭からの文字数）を検索
        last if ($n == @ref_list);                  #論文リストを全部検索したら（一致するものがなくても)ループ脱出
        $n++;
    }
    $cite_info[$i] = substr($ref[$i], $num[$i]);    #先程出した関数$numを頼りにAuthorをカット
    $cite_info[$i] =~ s/(\d+)\.\s+\D.+/$1\./;       #ページ数.の後に英文(For seeなど)が会った場合カット
}
my $result = join("\+",@cite_info);
$result =~ s/\+\s?\+/\+/sg;                         #+_+など+間が空白の場合（論文に一致しなかった）は間をカット
$result =~ s/\+\++/\+/sg;                           #上の置換で++と並んでいる場合は+に変換
print "$result\n";                                  #出力applescriptへいってらっしゃい

